/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import com.inprise.vbroker.util.ByteMapEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class UnGuardedByteMap
implements Cloneable,
Serializable {
    private transient ByteMapEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private static final long serialVersionUID = 1421746759512286392L;

    public UnGuardedByteMap() {
        this(101, 0.75f);
    }

    public UnGuardedByteMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public UnGuardedByteMap(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new ByteMapEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    private boolean areEqual(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        if (a == b) {
            return true;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        ByteMapEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            UnGuardedByteMap t = (UnGuardedByteMap)super.clone();
            t.table = new ByteMapEntry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (ByteMapEntry)this.table[i].clone() : null;
            }
            UnGuardedByteMap unGuardedByteMap = t;
            return unGuardedByteMap;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean containsKey(byte[] key) {
        ByteMapEntry[] tab = this.table;
        int hash = this.getHash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        ByteMapEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && this.areEqual(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Enumeration elements() {
        return new ByteMapEnumerator(null, this.table, false);
    }

    public Object get(byte[] key) {
        ByteMapEntry[] tab = this.table;
        int hash = this.getHash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        ByteMapEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && this.areEqual(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    private int getHash(byte[] key) {
        int hash = 0;
        for (int i = 0; i < key.length; ++i) {
            hash ^= key[i];
        }
        return hash;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new ByteMapEnumerator(null, this.table, true);
    }

    public Object put(byte[] key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        ByteMapEntry[] tab = this.table;
        int hash = this.getHash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        ByteMapEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && this.areEqual(e.key, key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        e = new ByteMapEntry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        int origlength = s.readInt();
        int elements = s.readInt();
        int length = (int)((float)elements * this.loadFactor) + elements / 20 + 3;
        if (length > elements && (length & 1) == 0) {
            --length;
        }
        if (origlength > 0 && length > origlength) {
            length = origlength;
        }
        this.table = new ByteMapEntry[length];
        this.count = 0;
        while (elements > 0) {
            byte[] key = (byte[])s.readObject();
            Object value = s.readObject();
            this.put(key, value);
            --elements;
        }
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        ByteMapEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        ByteMapEntry[] newTable = new ByteMapEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            ByteMapEntry old = oldTable[i];
            while (old != null) {
                ByteMapEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public Object remove(byte[] key) {
        ByteMapEntry[] tab = this.table;
        int hash = this.getHash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        ByteMapEntry e = tab[index];
        ByteMapEntry prev = null;
        while (e != null) {
            if (e.hash == hash && this.areEqual(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            String s1 = k.nextElement().toString();
            String s2 = e.nextElement().toString();
            buf.append(String.valueOf(new StringBuffer(String.valueOf(s1)).append("=").append(s2)));
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.count);
        for (int index = this.table.length - 1; index >= 0; --index) {
            ByteMapEntry entry = this.table[index];
            while (entry != null) {
                s.writeObject(entry.key);
                s.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    class ByteMapEnumerator
    implements Enumeration {
        boolean keys;
        int index;
        ByteMapEntry[] table;
        ByteMapEntry entry;

        ByteMapEnumerator(UnGuardedByteMap this$0, ByteMapEntry[] table, boolean keys) {
            this.table = table;
            this.keys = keys;
            this.index = table.length;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                ByteMapEntry e = this.entry;
                this.entry = e.next;
                return this.keys ? e.key : (byte[])e.value;
            }
            throw new NoSuchElementException("ByteMapEnumerator");
        }
    }
}

